vertex_shader_source = """
#version 100

uniform mat4 u_ortho;

precision mediump float;

attribute vec2 a_position;
      
varying vec2 position;
      
void main()
{   
    gl_Position = u_ortho * vec4( a_position, 0.0, 1.0 );
    position = a_position;
}
"""

from SDL_OpenGL import Sdl, Wgl, Program, VBO, Uniform, Scheduler, Task

sdl = Sdl('OpenGL', ratio = 1.0)
wgl = Wgl(sdl)

        
program = Program(wgl, vs_source=vertex_shader_source, fs_filename='shader.c')
if not program.is_ready:
    sdl.quit()
wgl.add_program(program)
sdl.register_drawing(wgl)

# Background color :
wgl.set_clear_color(0, 0, 0)

# Attributes :
#coords = [(-1.0, 1.0), (1.0, 1.0), (1.0, -1.0), (-1.0, -1.0)]
coords = [(0.0, 1.0), (1.0, 1.0), (1.0, 0.0), (0.0, 0.0)]

triangles_a = VBO('attributes')
triangles_a.specify_attributes({'name':'a_position', 'dtype':'float', 'dim':2})
triangles_a.load(coords)

# Uniforms :
time_u = Uniform('u_time', 'float')
time_u.set_value((0.0,))
ortho_u = Uniform.Ortho('u_ortho', 0.0, 1.0, 0.0, 1.0, -1.0, 1.0)
sdl.register_resize(ortho_u)


# Plug the attributes + uniforms in the rendering program :
program.plug('triangles', 'triangle_fan', (triangles_a,), (time_u, ortho_u))


def set_time(t_now, t_last, t_start):
    time_u.set_value((t_now/1000.0,))
    return True, True


scheduler = Scheduler(sdl, fps=60)
set_time_task = Task(set_time, -1.0, name='update_time')

scheduler.enqueue_now(set_time_task)

sdl.loop()
        
scheduler.stop()

sdl.quit()
