#version 100
   
precision mediump float;

uniform float u_time;

varying vec2 position;

void main() {
   vec2 p = position;
   vec2 q = p;
   
   float d = abs(cos(u_time / 3.0));
   d = 1.0 / (d*d);
   p = p - vec2(0.5);
   float a = u_time;
   float ca = cos(a);
   float sa = sin(a);
   p = mat2(ca, sa, -sa, ca) * p;
   p = fract(d * p);
   p = p - vec2(0.5);
   
   float l = 4.0 * dot(p, p);
   vec3 color;
   
   if (l < 1.0)
      color = vec3(sqrt(1.0 - l * l) * 0.99);
   else
      color = vec3(0.0, 0.0, abs(q.y - 0.5) + abs(q.x - 0.5));
   
   
   gl_FragColor = vec4(color, 1.0);
}
