
struct Uniform_data {
    time: f32,
    scale: vec2<f32>,
};

@group(0) @binding(0) var<uniform> u_data: Uniform_data;

@fragment

fn main(@location(0) position: vec2f) -> @location(0) vec4f
{
    let p = position - vec2(0.5);
   
    let d = abs(cos(u_data.time / 3.0));
    let e = 1.0 / (d*d);
    let ca = cos(u_data.time);
    let sa = sin(u_data.time);
    
    let v = fract(e * (mat2x2f(ca, sa, -sa, ca) * p)) - vec2(0.5);
   
    let l = 4.0 * dot(v, v);

    var color: vec3f;

    if l < 1.0
    {
        color = vec3f(sqrt(1.0 - l * l) * 0.99);
    }
    else
    {
        color = vec3f(0.0, 0.0, abs(position.y - 0.5) + abs(position.x - 0.5));
    }

    return vec4f(color, 1.0);
}
